<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:ns3="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:ns4="http://www.sec.gov/edgar/mai_drp"
	xmlns:n2="http://www.sec.gov/edgar/maifiler"	>
	
	<!-- Item 1 templates -->
	
<xsl:template name="Item1" ><link href="style.css" rel="stylesheet" type="text/css" />
<link href="MAI_print.css" rel="stylesheet" type="text/css" />

<div id="maiItem1">
  <div class="contentwrapper">
    <div class="content">
      <h1>Item 1 Identifying Information</h1>
      
      <xsl:if test="n2:edgarSubmission/n2:headerData/n2:submissionType = 'MA-I/A'">
      <div>
        <div>
        <div class="tdStyle1 tditem10col1100px" >Is this an amendment to change identifying information regarding the applicant in part A below? </div>
       <div class="yesNo" style="float:right; margin-top:-19px;">

								<xsl:choose>
									<xsl:when test="n2:isAmendment= 'Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								YES
								<xsl:choose>
									<xsl:when test="n2:isAmendment= 'N'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								NO

							</div>
        </div>
		<div style="clear:both;"></div>
      </div>
      </xsl:if>
      
      <h3>A. The Individual</h3>
      <div class="form1">
        <div class="mainDiv2" style="margin-left:0; margin-right:0;">
          <div class="formTable1" style="margin-left:0; margin-right:0;">
          	<div class="tdStyle1 tditem10col1100px">
          		Full Legal Name:
          	</div>
          </div>
          <div class="formTable1" style="margin-left:0; margin-right:0;">
          	<div class="tdStyle1 tditem10col1100px">
				Enter all the letters of each name and not initials or other abbreviations.
				  If no middle name, enter NMN on that line.
          	
          	</div>
			<div style="clear:both;"></div>
          </div>
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">Last Name:</div>
            <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:applicantName/ns2:lastName" />
				 
				</div>
				<div style="clear:both;"></div>
          </div>
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">First Name:</div>
            <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:applicantName/ns2:firstName" />
				 
				</div>
				<div style="clear:both;"></div>
          </div>
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px"> Middle Name:
              </div>
            <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:applicantName/ns2:middleName" />
				 
				</div>
				<div style="clear:both;"></div>
          </div>
           <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px"> Suffix:</div>
              <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:applicantName/ns2:suffix" />
				 
				</div>
				<div style="clear:both;"></div>
          </div>
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">Individual <em>CRD</em> No.: (if any)</div>
            <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:applicantCrdNum" />
				 
				</div>
            <div style="clear:both;"></div>
          </div>
		  <div style="clear:both;"></div>
        </div>
        <h2>B. <em>Municipal Advisory Firms</em> Where the Individual Is Employed</h2>
        <p>In providing your responses, please note that the definition of "<em>employee</em>" 
         for purposes of this form includes an independent contractor who engages in 
         <em>municipal advisory activities</em> on behalf of a <em>municipal advisory firm</em>. 
         See Glossary of Terms. </p>
       
        <div class="mainDiv2" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">Is the individual employed at more than one 
             <em>municipal advisory firm</em>? </div>
            <div class="tdStyle1 tditem10col2">
				<xsl:choose>
					<xsl:when test="n2:hasMoreThanOneAdvisoryFirms = 'Y' or n2:hasMoreThanOneAdvisoryFirms  = 'y'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				YES
				<xsl:choose>
					<xsl:when test="n2:hasMoreThanOneAdvisoryFirms = 'N' or n2:hasMoreThanOneAdvisoryFirms  = 'n'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				NO
			</div>
			<div style="clear:both;"></div>
          </div>
           <xsl:if			test="(count(n2:noOfAdvisoryFirms) &gt; 0)">
          <div class="tableRowNoBorder">
            <div class="tdStyle1 tditem10col1100px">Enter the number of <em>municipal advisory firms</em> the individual is employed with 
            (sole proprietors not employed with any other firm enter 1).
              <p>(For individuals who are employed with more than one firm, provide 
               the information required by this Item 1-B for each such firm. For sole proprietors, 
               enter the legal name under which you conduct your <em>municipal advisor-related</em>
               activities, and skip to Item 1-B.1.)</p></div>
           <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:noOfAdvisoryFirms" />  
				</div>
				<div style="clear:both;"></div>
          </div>
          </xsl:if>
          </div>
       <xsl:if			test="(count(n2:noOfAdvisoryFirms) &gt; 0)">   
      <xsl:for-each
			select="n2:municipalAdvisorOffices/n2:municipalAdvisorOffice">
			
          <div class="mainDiv2" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px"><em>Municipal Advisory Firm's</em> CIK: 
              </div>
           <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:filerId" />  
				<!-- id="advisoryFirmInfoList0.municipalAdvisoryFirmInfo.filerType.filerId" -->
				 
				</div>
				<div style="clear:both;"></div>
          </div>
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">Full Legal Name of <em>municipal advisory firm</em> with which 
             the individual is employed: </div>
           <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:municipalFirm/n2:municipalFirmName" />  
				 
				</div>
				<div style="clear:both;"></div>
          </div>
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">Name under which <em>municipal advisor-related</em> business is
             primarily conducted, if different from above:</div>
            <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:municipalFirm/n2:municipalDbaName" />  
				 
				</div>
				<div style="clear:both;"></div>
          </div>
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">Date that the individual's most recent employment with this
             <em>municipal advisory firm</em> commenced (MM/DD/YYYY):</div>
            <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<!-- <xsl:value-of select="n2:municipalAdvisorOffices/n2:municipalAdvisorOffice/n2:municipalFirm/n2:recentEmploymentCommencedDate" />
				 -->
				<!-- n2:municipalAdvisorOffices/municipalAdvisorOffice/municipalFirm/recentEmploymentCommencedDate  -->
				<xsl:value-of select="n2:municipalFirm/n2:recentEmploymentCommencedDate" />
            </div>
			<div style="clear:both;"></div>
          </div>
          <div class="tableRowNoBorder">
            <div class="tdStyle1 tditem10col1100px">Does the individual have an independent contractor relationship 
             with the above-named firm?</div>
                        <div class="tdStyle1 tditem10col2">

								<xsl:choose>
									<xsl:when test="n2:municipalFirm/n2:isIndependentRelatioship = 'Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								YES
								<xsl:choose>
									<xsl:when test="n2:municipalFirm/n2:isIndependentRelatioship = 'N'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								NO

							</div>
			<div style="clear:both;"></div>
		  </div>
        </div>
        <h2>(1) <em>Municipal Advisory Firm's</em> Registration Information:</h2>
        <p>Notification will automatically be sent to the Login CIK, Submission Contact, 
        and Primary Issuers. Specify additional addresses below.</p>
        <div class="mainDiv2" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">Is the <em>municipal advisory firm</em> currently registered 
            on Form MA as a <em>municipal advisor</em>? (Answer &quot;Yes&quot; if you have 
            already filed Form MA and your application for registration on that form has 
            been approved.  Otherwise, answer &quot;No.&quot;) </div>
            <div class="tdStyle1 tditem10col2">

								<xsl:choose>
									<xsl:when test="(count(n2:maRegistration/n2:secRegistration/ns2:fileNumber) &gt; 0)">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />YES
										<img src="Images/radio-checked.jpg"  alt="radio button checked"/>NO
									</xsl:otherwise>
								</xsl:choose>
				</div>
				<div style="clear:both;"></div>
			</div>
		<!--  <xsl:if test="(count(n2:maRegistration/n2:secRegistration/ns2:fileNumber) &gt; 0)" > -->
          <div class="tableRowNoBorder">
               <div class="tdStyle1 tditem10col1100px"><em>SEC</em> File No.:</div>
	           <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
					<xsl:value-of select="n2:maRegistration/n2:secRegistration/ns2:fileNumber" />
			   </div>
			   <div style="clear:both;"></div>
          </div>
         <!--  </xsl:if> -->
          
          
          <xsl:if test="(count(n2:maRegistration/n2:notSecRegistered) &gt; 0)" >
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">If &quot;No,&quot; has the <em>municipal advisory firm</em>
             filed a Form MA application? </div>
            <div class="tdStyle1 tditem10col2">
				<xsl:choose>
					<xsl:when test="(count(n2:maRegistration/n2:notSecRegistered/n2:hasFiled) &gt; 0)">
						<img src="Images/radio-checked.jpg"  alt="radio button checked"/>YES
						<img src="Images/radio-unchecked.jpg"  alt="radio button unchecked"/>NO
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg"  alt="radio button unchecked"/>YES
						<img src="Images/radio-checked.jpg"  alt="radio button checked"/>NO
					</xsl:otherwise>
				</xsl:choose>

				</div>
				<div style="clear:both;"></div>
          </div>
          <div class="tableRow">
            <div  class="tdStyle1 tditem10col1100px">Form MA Filing Date: (MM/DD/YYYY): </div>
           <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:maRegistration/n2:notSecRegistered/n2:hasFiled/n2:filingDate" />
            </div>
			<div style="clear:both;"></div>
          </div>
          
          <div class="tableRowNoBorder">
            <div  class="tdStyle1 tditem10col1100px">EDGAR CIK No.: </div>
          <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:maRegistration/n2:notSecRegistered/n2:hasFiled/n2:cik" />
				</div>
				<div style="clear:both;"></div>
          </div>
        <!--   <xsl:if test="(count(n2:maRegistration/n2:notSecRegistered/n2:hasFiled) &gt; 0)" > -->
          <!-- </xsl:if> -->
         <xsl:if test="(count(n2:maRegistration/n2:notSecRegistered/n2:explanation) &gt; 0)" >
          <div class="tableRowNoBorder">
            <div class="tdStyle1 tditem10col1100px">If &quot;No,&quot; please provide an explanation:</div>
           <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:maRegistration/n2:notSecRegistered/n2:explanation" />  
				</div>
				<div style="clear:both;"></div>
          </div>
          </xsl:if>
          
          
          
          </xsl:if>
        </div>
        
        
        
        <h3>(2) Office</h3>
        <p>Enter the requested information for each office of the <em>municipal advisory firm</em> 
         where the individual is or will be physically located, and each office from which the individual
         is or will be supervised: </p>
       
        <xsl:for-each
			select="n2:advisorOffices/n2:advisorOffice">
         <div class="mainDiv2 " style="margin-left:0; margin-right:0;">
          <div style="margin-left:0; margin-right:0;">
                      <div class="tdStyle1 tditem10col1100px LocatedAtSupervisedFrom label2_0" >
                      	The individual is or will be 
								<xsl:choose>
									<xsl:when test="n2:locationInfo = 'LOCATED'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Located At
								<xsl:choose>
									<xsl:when test="n2:locationInfo = 'SUPERVISED'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Supervised From
								</div>
          </div>
		  <div style="clear:both;"></div>
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">Start Date: </div>
           <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:startDate" />
            </div>
            <div style="clear:both;"></div>
          </div>
            
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">Street Address 1:</div>
        <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:addressInfo/ns2:address/ns1:street1" />
				</div>
				<div style="clear:both;"></div>
          </div>
          
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">Street Address 2:</div>
          <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:addressInfo/ns2:address/ns1:street2" />
				</div>
				<div style="clear:both;"></div>
          </div>
          
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">City:</div>
          <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:addressInfo/ns2:address/ns1:city" />
				</div>
				<div style="clear:both;"></div>
          </div>
          
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">State/Country:</div>
           <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:addressInfo/ns2:address/ns1:stateOrCountry" />
				</div>
				<div style="clear:both;"></div>
          </div>
         
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1100px">Postal Code:</div>
           <div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
				<xsl:value-of select="n2:addressInfo/ns2:address/ns1:zipCode" />
				</div>
				<div style="clear:both;"></div>
          </div>
          
          <div class="tableRowNoBorder">
            <div class="tdStyle1 tditem10col1100px"><strong>Private Residence Check Box:</strong> Is the Office
             of Employment address a private residence?
            <!-- If the office where the applicant is or will be physically 
            located is a private residence, check this box:  -->
              <p>A private residential address will not be included in publicly 
              available versions of this registration form.</p></div>
          <div class="tdStyle1 tditem10col2">
				<xsl:choose>
					<xsl:when test="n2:addressInfo/ns2:residentialAddressFlag = 'Y' or n2:addressInfo/ns2:residentialAddressFlag  = 'y'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				YES
				<xsl:choose>
					<xsl:when test="n2:addressInfo/ns2:residentialAddressFlag = 'N' or n2:addressInfo/ns2:residentialAddressFlag  = 'n'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				NO
			</div>
			<div style="clear:both;"></div>			
          </div>
		  <div style="clear:both;"></div>	
        </div>
        </xsl:for-each>
        </xsl:for-each>
        </xsl:if> 
      </div>
    </div>
  </div>
</div>



</xsl:template>

</xsl:stylesheet>